<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
defined('MOODLE_INTERNAL') || die();

/**
 * Access are defined here.
 *
 * @package     local_booste
 * @category    access
 * @copyright   2022 ENSAM <you@example.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$capabilities = array(
        
        'local_booste/boostes:delete' => array(
                'riskbitmask' => RISK_DATALOSS,
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => array(
                        'manager' => CAP_ALLOW,
                        'editingteacher' => CAP_ALLOW,
                        'coursecreator' => CAP_ALLOW,
                )
        ),

        'local_booste/ext_activities:delete' => array(
                'riskbitmask' => RISK_DATALOSS,

                'captype' => 'write',
                'contextlevel' => CONTEXT_USER,
                'archetypes' => array(
                        'manager' => CAP_ALLOW
                )
        ),
        
        'local_booste/tags:delete' => array(
                'riskbitmask' => RISK_DATALOSS,

                'captype' => 'write',
                'contextlevel' => CONTEXT_USER,
                'archetypes' => array(
                        'manager' => CAP_ALLOW
                )
        ),
);