<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

namespace local_booste\form;

use local_booste\helper;

defined('MOODLE_INTERNAL') || die();

class booste_third_form extends \core\form\persistent {

    /** @var string Persistent class name. */
    protected static $persistentclass = \local_booste\booste::class;

    protected static $fieldstoremove = array('submitbutton','mform_isexpanded_id_header_suggestions','mform_isexpanded_id_header_tags','mform_isexpanded_id_header_steps');
    

    public function definition() {

        global $PAGE;
        global $CFG;

        $mform = $this->_form;
        $booste = $this->get_persistent();

        $mform->addElement('html', ' <div id="booste_loader" class="overlay"><div class="loader"></div></div> ');

        $points = array(
            'all' => helper::get_booste_points($booste->get('id'), "all"),
            'synthesis' => helper::get_booste_points($booste->get('id'), "synthesis"),
            'evaluation' => helper::get_booste_points($booste->get('id'), "evaluation"),
            'analysis' => helper::get_booste_points($booste->get('id'), "analysis"),
            'application' => helper::get_booste_points($booste->get('id'), "application"),
            'comprehension' => helper::get_booste_points($booste->get('id'), "comprehension"),
            'knowledge' => helper::get_booste_points($booste->get('id'), "knowledge")
        );

        $mform->addElement('header', 'header_aav', get_string('header_aav', 'local_booste'));
        $mform->addHelpButton('header_aav', 'header_aav', 'local_booste');
        $mform->addElement('html', '<div class="container">
                                        <div class="row">
                                            <div class="col">
                                                <div id="objective_list"></div>
                                            </div>
                                            <div class="col">
                                                <div id="taxonomy_chart">
                                                </div>
                                            </div>
                                        </div>
                                    </div>');


        $mform->addElement('header', 'header_tags', get_string('tags', 'local_booste'));

        $tags = helper::get_booste_tags($booste->get('id'));
        $tags_html = '';
        foreach($tags as $tag) {
            $tags_html .= '<span class="badge badge-info mb-3 mr-1" style="font-size: 100%">'.$tag.'</span>';
        }

        $mform->addElement('html',
         '
          <div class="form-group row  fitem" id="tags">
            <div class="col-md-3 col-form-label d-flex pb-0 pr-md-0">
            <label class="d-inline word-break"><b>'.get_string('tags', 'local_booste').'</b></label>
            </div>
            <div id="tags" class="col-md-9 form-inline align-items-start felement">
                '.$tags_html.'
            </div>
          </div>');

        if(helper::can_edit_form($booste->get('id'))) {
            $mform->addHelpButton('header_tags', 'header_tags', 'local_booste');

            $urleditparams = $CFG->wwwroot."/local/booste/forms/booste_first_form.php?booste=".$this->_customdata['booste']."&course=".$this->_customdata['course'];
            $urleditgoals = $CFG->wwwroot."/local/booste/forms/booste_second_form.php?booste=".$this->_customdata['booste']."&course=".$this->_customdata['course'];

            //$url = new \moodle_url("/local/booste/forms/booste_first_form.php", array("course" => $this->_customdata['course'], "booste" => $this->_customdata['booste']));

            $editarray=array();
            $editarray[] = $mform->createElement('button', 'edit_params', get_string('edit_params', 'local_booste'), array('onclick' => "location.href='".$urleditparams."'"));
            $editarray[] = $mform->createElement('button', 'edit_goals', get_string('edit_goals', 'local_booste'), array('onclick' => "location.href='".$urleditgoals."'"));
            $mform->addGroup($editarray, 'editar', '', ' ', false);
        }

        $mform->addElement('header', 'header_suggestions', get_string('header_suggestions', 'local_booste'));
        $mform->addHelpButton('header_suggestions', 'header_suggestions', 'local_booste');

        $taxonomy_params = array("data-action" => "refresh_recommendations", "data-id" => $booste->get('id'), "hidden" => true);
        $buttonarray=array();
        $buttonarray[] = $mform->createElement('button', 'all', get_string('all'), $taxonomy_params);
        $buttonarray[] = $mform->createElement('button', 'knowledge', get_string('knowledge', 'local_booste'), $taxonomy_params);
        $buttonarray[] = $mform->createElement('button', 'comprehension', get_string('comprehension', 'local_booste'), $taxonomy_params);
        $buttonarray[] = $mform->createElement('button', 'application', get_string('application', 'local_booste'), $taxonomy_params);
        $buttonarray[] = $mform->createElement('button', 'analysis', get_string('analysis', 'local_booste'), $taxonomy_params);
        $buttonarray[] = $mform->createElement('button', 'synthesis', get_string('synthesis', 'local_booste'), $taxonomy_params);
        $buttonarray[] = $mform->createElement('button', 'evaluation', get_string('evaluation', 'local_booste'), $taxonomy_params);
        $mform->addGroup($buttonarray, 'buttonar', '', ' ', false);

        $mform->addElement('html', '<div class="container mt-2">
                                        <div class="row gx-5">
                                            <div class="col-sm">
                                                <div id="all_suggested_activities" name="taxonomy">
                                                </div>
                                                <div id="synthesis_suggested_activities" name="taxonomy" hidden="hidden" disabled="true">
                                                </div>
                                                <div id="evaluation_suggested_activities" name="taxonomy" hidden="hidden" disabled="true">
                                                </div>
                                                <div id="analysis_suggested_activities" name="taxonomy" hidden="hidden" disabled="true">
                                                </div>
                                                <div id="application_suggested_activities" name="taxonomy" hidden="hidden" disabled="true">
                                                </div>
                                                <div id="comprehension_suggested_activities" name="taxonomy" hidden="hidden" disabled="true">
                                                </div>
                                                <div id="knowledge_suggested_activities" name="taxonomy" hidden="hidden" disabled="true">
                                                </div>
                                            </div>
                                            <div class="col-sm">
                                                <div id="activity_helper">
                                                </div>
                                            </div>
                                        </div>
                                    </div>');

        $mform->addElement('header', 'header_steps', get_string('header_steps', 'local_booste'));
        //$mform->addHelpButton('header_steps', 'header_steps', 'local_booste');
        $mform->addElement('html', '<div id="booste_step_list"></div>');

        if(helper::can_edit_form($booste->get('id'))) {
            $mform->addElement('button', 'booste_step', get_string('add_step', 'local_booste'), 
                    array(
                        "id" => "id_booste_step", 
                        "data-action" => "newboostepopup",
                        "data-formname" => "booste_step",
                        "data-id" => $this->_customdata['booste'],
                        'data-editid' => 0
                    ));
        }

        $chooserconfig = (object) [
            'tabmode' => get_config('core', 'activitychoosertabmode'),
        ];


        $submitarray=array();
        if(helper::can_edit_form($booste->get('id'))) {
            $submitarray[] = $mform->createElement('submit', 'submitbutton', get_string('save'));
            $submitarray[] = $mform->createElement('button', 'deploy', get_string('deploy', 'local_booste'));
            $submitarray[] = $mform->createElement('submit', 'submitbefore', get_string('booste_before', 'local_booste'));
        }
        else {
            $submitarray[] = $mform->createElement('button', 'button_before', get_string('booste_before', 'local_booste'), 
                array("onclick" => "window.location.href = '".$CFG->wwwroot."/moodle/local/booste/forms/booste_second_form.php?course=".$this->_customdata['course']."&booste=".$booste->get('id')."';"));
        }
        $submitarray[] = $mform->createElement('button', 'return_index', get_string('return_index', 'local_booste'), array("onclick" => "window.location.href = '".$CFG->wwwroot."/local/booste/index.php?course=".$this->_customdata['course']."';"));
        $mform->addGroup($submitarray, 'submitar', '', ' ', false);


        $PAGE->requires->js_call_amd('local_booste/refresh_data', 'refreshBoosteDatas', ['id' => $booste->get('id'), 'formName' => "booste_step"]);
        $PAGE->requires->js_call_amd('local_booste/refresh_data', 'refreshBoosteDatas', ['id' => $booste->get('id'), 'formName' => "objective"]);
        $PAGE->requires->js_call_amd('local_booste/refresh_data', 'refreshRecommendations', ['points' => $points]);
        $PAGE->requires->js_call_amd('local_booste/activity_form', 'init', [$this->_customdata['course'], $this->_customdata['booste'], $chooserconfig]);
        $PAGE->requires->js_call_amd('local_booste/activity_form', 'recommendations', [$this->_customdata['course'], $this->_customdata['booste'], "all", $points['all']]);
        $PAGE->requires->js_call_amd('local_booste/activity_form', 'initChart', [$this->_customdata['booste']]);
        if(helper::can_edit_form($booste->get('id'))) {
            $PAGE->requires->js_call_amd('local_booste/popup_form', 'init', ['booste_step', 1]);
            $PAGE->requires->js_call_amd('local_booste/popup_form', 'deployBooste', [array('id' => $this->_customdata['booste'], 'is_deployed' => $booste->get('is_deployed')), $this->_customdata['course']]);
        }

        $PAGE->requires->string_for_js('all', 'local_booste');

        $mform->setExpanded('header_suggestions');
        $mform->setExpanded('header_tags');
        $mform->setExpanded('header_steps');
    }
}
