<?php

namespace local_booste\form;

use context;
use moodle_url;
use local_booste\helper;

defined('MOODLE_INTERNAL') || die();

class challenge_form extends \core_form\dynamic_form {

    public function definition() {

        global $DB;

        $mform = $this->_form;

        $mform->addElement('hidden', 'booste');
        $mform->setConstant('booste', $this->_ajaxformdata['id']);
        $mform->setType('booste', PARAM_INT);

        $mform->addElement('hidden', 'challengedata');
        $mform->setConstant('challengedata', $this->_ajaxformdata['challengedata']);
        $mform->setType('challengedata', PARAM_RAW);

        $mform->addElement('static', 'description', "<i class='icon fa fa-warning'></i>",
        get_string('add_challenge_warning', 'local_booste'));

        $mform->addElement('text', 'name', get_string('name'));
        $mform->addRule('name', get_string('error'), 'required');
        
    }

    protected function get_context_for_dynamic_submission(): context {
        return \context_system::instance();
    }

    protected function check_access_for_dynamic_submission(): void {
        // TODO: Implement check_access_for_dynamic_submission() method.
    }

    public function process_dynamic_submission() {

        global $DB;
        $data = $this->_ajaxformdata;

        $fields = ['challenge', 'learning_mode'];
        $challengedata = json_decode($data['challengedata']);

        if($challengedata) {
            helper::delete_booste_tags($this->_ajaxformdata['booste'], $fields);
            helper::create_booste_tags($this->_ajaxformdata['booste'], $challengedata, $fields);
    
            $field = $DB->get_field('local_booste_list_fields', 'id', array('name' => 'challenge'));
            $record = $DB->insert_record('local_booste_list_tags', array(
                'field' => $field,
                'name' => $data['name'],
                'custom' => 1));
    
            $boostetag = $DB->insert_record('local_booste_tags', array(
                'booste' => $data['booste'],
                'tag' => $record));
        }
        else {
            throw new \moodle_exception(get_string('error'));
        }
    

        return [];
    }

    public function set_data_for_dynamic_submission(): void {
        // TODO: Implement set_data_for_dynamic_submission() method.
    }

    protected function get_page_url_for_dynamic_submission(): moodle_url {
                return new moodle_url('/');
    }
}