<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
namespace local_booste;

/**
 * Booste Main class
 *
 * @package    local_booste
 * @copyright  XXX
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class booste extends \core\persistent {

    /** Table name for the persistent. */
    const TABLE = 'local_booste';

    /**
     * Return the definition of the properties of this model.
     *
     * @return array
     */
    protected static function define_properties() {
        return array(
                'id' => array(
                        'type' => PARAM_INT,
                ),
                'name' => array(
                        'type' => PARAM_NOTAGS,
                        'null' => NULL_ALLOWED,
                        'default' => null
                ),
                'timestamp' => array(
                        'type' => PARAM_INT,
                ),
                'privacy' => array(
                        'type' => PARAM_INT,
                ),
                'course' => array(
                        'type' => PARAM_INT,
                ),
                
                'group_size' => array(
                        'type' => PARAM_INT,
                        'null' => NULL_ALLOWED,
                        'default' => null
                ),
                
                'created_by' => array(
                        'type' => PARAM_INT,
                ),
                'description' => array(
                        'type' => PARAM_NOTAGS,
                        'null' => NULL_ALLOWED,
                        'default' => null
                ),
                'is_deployed' => array(
                        'type' => PARAM_INT,
                        'default' => 0
                ),
                'is_complete' => array(
                        'type' => PARAM_INT,
                        'default' => 0
                ),
        );
    }
}
