<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

namespace local_booste\form;

use local_booste\helper;

defined('MOODLE_INTERNAL') || die();

class booste_second_form extends \core\form\persistent {

    /** @var string Persistent class name. */
    protected static $persistentclass = \local_booste\booste::class;

    protected static $fieldstoremove = array('create_challenge','mform_isexpanded_id_header_challenges','mform_isexpanded_id_header_evaluations','mform_isexpanded_id_header_learning_activities','mform_isexpanded_id_header_objectives');
    protected static $foreignfields = array('course', 'evaluation', 'objective', 'place', 'theme', 'method', 'booste', 'challenge', 'eval_type','learning_mode', 'redirect','submitbutton','submitnext','submitbefore');

    /**
     * Define the form.
     */
    public function definition() {

        global $DB;
        global $PAGE;
        global $CFG;


        $mform = $this->_form;
        $booste = $this->get_persistent();


        $mform->addElement('hidden', 'course');
        $mform->setConstant('course',  $booste->get('course'));

        $mform->addElement('hidden', 'created_by');
        $mform->setConstant('created_by', $booste->get('created_by'));

        $mform->addElement('header', 'header_challenges', get_string('challenge', 'local_booste'));


        $challenges = helper::get_records_from_field("challenge");
        $select_challenge = $mform->addElement('autocomplete', 'challenge', "<b>".get_string('challenge', 'local_booste')."</b>", $challenges, array('multiple' => true));
        //$mform->addHelpButton('challenge', 'challenge', 'local_booste');
        //$mform->addRule('challenge', get_string('error'), 'required');

        if(helper::can_edit_form($booste->get('id'))) {

            $mform->addElement('static', 'add_challenge_help', '',
            '<i>'.get_string('add_challenge_help', 'local_booste').'</i>');

            $mform->addElement('button', 'add_challenge', get_string('add_challenge', 'local_booste'), array(
                'id' => 'id_challenge', 
                "data-action" => "newboostepopup",
                'data-formname' => 'challenge', 
                'data-id' => $booste->get('id'),
                'data-editid' => 0
            ));
        }

        $mform->addElement('header', 'header_objectives', get_string('header_objectives', 'local_booste').
        '&nbsp;<i class="icon fa fa-exclamation-circle text-danger fa-fw" title="'.get_string('required').'" aria-label="'.get_string('required').'"></i>');
        
        $mform->addElement('html', '<div id="objective_list"></div>');

        if(helper::can_edit_form($booste->get('id'))) {
            $mform->addElement('button', 'objective', get_string('add_objective', 'local_booste'), array(
                'id' => 'id_objective', 
                "data-action" => "newboostepopup",
                'data-formname' => 'objective', 
                'data-id' => $booste->get('id'),
                'data-editid' => 0
            ));
        }
        
        $mform->addElement('header', 'header_evaluations', get_string('header_evaluations', 'local_booste'));

        $mform->addElement('html', '<div id="evaluation_list"></div>');

        if(helper::can_edit_form($booste->get('id'))) {
            $mform->addElement('button', 'evaluation', get_string('add_evaluation', 'local_booste'), array(
                'id' => 'id_evaluation', 
                "data-action" => "newboostepopup",
                'data-formname' => 'evaluation', 
                'data-id' => $booste->get('id'),
                'data-editid' => 0
            ));
        }

        $mform->addElement('header', 'header_learning_activities', get_string('header_learning_activities', 'local_booste'));

        $learning_mode_array   = array();
        $learning_modes = $DB->get_records_sql_menu('SELECT id, name FROM {local_booste_list_tags} WHERE field = (SELECT id FROM {local_booste_list_fields} WHERE name = (?))', array("learning_mode"));
        foreach($learning_modes as $key => $value) {
            $records[$key] = get_string($value, 'local_booste');
            $records[$key] = str_replace(array('[',']'), '',$records[$key]);
            $learning_mode_array[] = $mform->createElement('advcheckbox', 'learning_mode'.$key, '', 
                                                            "<div class='learning-mode'><img width='90' src='".$CFG->wwwroot."/local/booste/pix/".$value.".png'/>".$records[$key]."</div>", array('group' => 1), array(0,$key));
        }
        
        $mform->addElement('static','learning-mode_usage','',get_string('learning_mode_usage', 'local_booste'));

        $mform->addGroup($learning_mode_array, 'learning_mode_ar', "<b>".get_string('learning_mode_ar', 'local_booste')."</b>", array(' '), false);
        $mform->addHelpButton('learning_mode_ar', 'learning_mode', 'local_booste');
        $mform->addElement('static','learning-mode_source','','<i>' . get_string('learning_mode_source', 'local_booste') . '</i>');

        $mform->addElement('hidden', 'timestamp');
        $mform->setConstant('timestamp', $this->_customdata['timestamp']);
        $mform->setType('timestamp', PARAM_INT);

        $PAGE->requires->js_call_amd('local_booste/refresh_data', 'refreshBoosteDatas', [$booste->get('id'), "objective"]);
        $PAGE->requires->js_call_amd('local_booste/refresh_data', 'refreshBoosteDatas', [$booste->get('id'), "evaluation"]);
        if(helper::can_edit_form($booste->get('id'))) {
            $PAGE->requires->js_call_amd('local_booste/popup_form', 'init', ['objective', 1]);
            $PAGE->requires->js_call_amd('local_booste/popup_form', 'init', ['challenge', 1]);
            $PAGE->requires->js_call_amd('local_booste/popup_form', 'init', ['evaluation', 1]);
        }

        $mform->setExpanded('header_challenges');
        $mform->setExpanded('header_evaluations');
        $mform->setExpanded('header_learning_activities');
        $mform->setExpanded('header_objectives');

        $buttonarray=array();
        $buttonarray[] = $mform->createElement('submit', 'submitbutton', get_string('save'));
        if(helper::can_edit_form($booste->get('id'))) {
            $buttonarray[] = $mform->createElement('submit', 'submitbefore', get_string('booste_before', 'local_booste'));
            $buttonarray[] = $mform->createElement('submit', 'submitnext', get_string('booste_next', 'local_booste'));
        }
        else {
            $buttonarray[] = $mform->createElement('button', 'button_before', get_string('booste_before', 'local_booste'), 
                array("onclick" => "window.location.href = '".$CFG->wwwroot."/local/booste/forms/booste_first_form.php?course=".$this->_customdata['course']."&booste=".$booste->get('id')."';"));
            $buttonarray[] = $mform->createElement('button', 'button_next', get_string('booste_next', 'local_booste'), 
                array("onclick" => "window.location.href = '".$CFG->wwwroot."/local/booste/forms/booste_third_form.php?course=".$this->_customdata['course']."&booste=".$booste->get('id')."';"));
        }
        $buttonarray[] = $mform->createElement('button', 'return_index', get_string('return_index', 'local_booste'), array("onclick" => "window.location.href = '".$CFG->wwwroot."/local/booste/index.php?course=".$this->_customdata['course']."';"));
        $mform->addGroup($buttonarray, 'buttonar', '', ' ', false);


        if($booste) {
            $booste_challenges = helper::get_records_for_edit($booste->get('id'), "challenge");
            $booste_eval_types = helper::get_records_for_edit($booste->get('id'), "eval_type");
            $booste_learning_modes = helper::get_records_for_edit($booste->get('id'), "learning_mode");

            $mform->setDefault('eval_type', $booste_eval_types[0]);
            foreach($booste_learning_modes as $learning_mode) {
                $mform->setDefault('learning_mode'.$learning_mode, $learning_mode);
            }

            $select_challenge->setValue($booste_challenges);
        }
    }


}


