<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 *
 * @package    local_booste
 * @author     XXX
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_booste\form\booste_third_form;
use local_booste\booste;

require_once(__DIR__ . '/../../../config.php');
require_once($CFG->libdir.'/formslib.php');

global $DB;
global $PAGE;

$boosteid = required_param('booste', PARAM_INT);
$courseid = required_param('course', PARAM_INT);
$booste = booste::get_record(['id' => $boosteid]);
\local_booste\helper::header($courseid, $boosteid);

$canedit = \local_booste\helper::can_edit_form($boosteid);

$customdata = [
        'persistent' => $booste,
        'userid' => $USER->id,
        'timestamp' => time(),
        'course' => $courseid,
        'booste' => $boosteid
];

$mform = new booste_third_form($PAGE->url->out(false), $customdata, 'post', '', null, $canedit);

if ($mform->is_cancelled()) {
        redirect(new moodle_url('/local/booste/index.php', array('course' => $courseid)));
}
else if ($data = $mform->get_submitted_data()) {

        if($data->submitbefore) {     
                redirect(new moodle_url('/local/booste/forms/booste_second_form.php', array('booste' => $boosteid, 'course' => $courseid)));
        }

// We are done, so let's redirect somewhere.
}

echo $OUTPUT->header();
echo $OUTPUT->heading(get_string('heading','local_booste'));
echo $OUTPUT->heading(get_string('third_form','local_booste'), 3);

echo html_writer::link(new moodle_url('/local/booste/forms/booste_first_form.php', array('booste' => $boosteid, 'course' => $courseid)), get_string('first_form','local_booste')). " > ";
echo html_writer::link(new moodle_url('/local/booste/forms/booste_second_form.php', array('booste' => $boosteid, 'course' => $courseid)), get_string('second_form','local_booste')). " > ";
echo html_writer::link(new moodle_url('/local/booste/forms/booste_third_form.php', array('booste' => $boosteid, 'course' => $courseid)), get_string('third_form','local_booste'));

if(!$canedit) {
        echo " > " .html_writer::link(new moodle_url('/local/booste/index.php', array('course' => $courseid)), get_string('return_index','local_booste'));
}
$mform->display();

echo $OUTPUT->footer();
